<?php

class OracleHelper
{
	public static function getClobValue($tableName, $fieldName, $primaryKey, $pk)
	{
		$sql = 'SELECT LENGTH('.$fieldName.') AS NUM FROM '.$tableName.' WHERE '.$primaryKey.' = :PK';
		$cmd = Yii::app()->db->createCommand($sql);
		$cmd->bindParam(':PK', $pk);
		$num = $cmd->queryScalar();

		$content = '';

		$start = 1;
		$len = 2500; // fetch length per time

		while($start <= $num)
		{
			$ret = '';

			$sql = "BEGIN GET_CLOB(:TABLE_NAME, :FIELD_NAME, :PRIMARY_KEY, :PRIMARY_KEY_VALUE, :START_POS, :FETCH_LENGTH, :RETURN_VALUE); END;";

			$cmd = Yii::app()->db->createCommand($sql);
			$cmd->bindParam(':TABLE_NAME', $tableName);
			$cmd->bindParam(':FIELD_NAME', $fieldName);
			$cmd->bindParam(':PRIMARY_KEY', $primaryKey);
			$cmd->bindParam(':PRIMARY_KEY_VALUE', $pk);
			$cmd->bindParam(':START_POS', $start);
			$cmd->bindParam(':FETCH_LENGTH', $len);
			$cmd->bindParam(':RETURN_VALUE', $ret, PDO::PARAM_STR, 5000);
			$cmd->execute();

			$content .= $ret;
			$start = $start+$len;
		}

		return $content;
	}
}
